/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.Easings;
import lib.toma.animations.IEasing;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.AnimationType;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.IAnimationLoader;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IKeyframe;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.api.lifecycle.Registries;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.commons.lang3.tuple.Pair;

public class AnimationUtils {
    public static final IEasing DEFAULT_EASE_FUNC = Easings.EASE_IN_OUT_SINE;

    public static boolean isActiveOrScheduled(IAnimationPipeline pipeline, AnimationType<?> type) {
        return pipeline.has(type) || pipeline.hasScheduled(type);
    }

    public static <A extends IAnimation> A createAnimation(ResourceLocation providerPath, Function<IKeyframeProvider, A> creatorFunction) {
        AnimationEngine engine = AnimationEngine.get();
        IAnimationLoader loader = engine.loader();
        IKeyframeProvider provider = loader.getProvider(providerPath);
        return (A)((IAnimation)creatorFunction.apply(provider));
    }

    public static void encodeAnimationType(AnimationType<?> type, PacketBuffer buffer) {
        buffer.func_192572_a(type.getKey());
    }

    public static <A extends IAnimation> AnimationType<A> decodeAnimationType(PacketBuffer buffer) {
        return Registries.ANIMATION_TYPES.getElement(buffer.func_192575_l());
    }

    public static Pair<Float, Vector3f> getVectorWithRotation(Quaternion quaternion) {
        double value = Math.acos(quaternion.func_195894_d());
        double deg = Math.toDegrees(value * 2.0);
        double rad = deg * 0.01745329238474369;
        float f = (float)Math.sin(rad / 2.0);
        float x = f == 0.0f ? 0.0f : quaternion.func_195889_a() / f;
        float y = f == 0.0f ? 0.0f : quaternion.func_195891_b() / f;
        float z = f == 0.0f ? 0.0f : quaternion.func_195893_c() / f;
        return Pair.of((Object)Float.valueOf((float)deg), (Object)new Vector3f(x, y, z));
    }

    public static <K, V> V safeRet(Map<K, V> map, K key, V fallback) {
        V v = map.get(key);
        return v != null ? v : Objects.requireNonNull(fallback, "Fallback value cannot be null");
    }

    public static TreeMap<AnimationStage, IKeyframe[]> createSortedMap() {
        return new TreeMap<AnimationStage, IKeyframe[]>(AnimationStage::compareTo);
    }

    public static float linearInterpolate(float value, float prevValue, float delta) {
        return prevValue + (value - prevValue) * delta;
    }

    public static void dispatchEvents(float current, float prev, IAnimation source, IAnimationEvent[] eventCollection) {
        Minecraft client = Minecraft.func_71410_x();
        Arrays.stream(eventCollection).filter(event -> event.invokeAt() <= current && event.invokeAt() > prev).forEach(event -> event.dispatch(client, source));
    }

    public static void dispatchEventsMultiFlow(float progress1, float progress2, IAnimation source, IAnimationEvent[] events) {
        AnimationUtils.dispatchEvents(progress1, progress2, source, events);
        AnimationUtils.dispatchEvents(progress2, progress1, source, events);
    }
}

